@extends('layouts.dashboard')

@section('title', 'My Leaves')

@section('content')
<div class="container mx-auto px-4 py-6">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-6">
        <div>
            <h1 class="text-2xl font-bold text-gray-800">My Leaves</h1>
            <p class="text-gray-600 mt-1">View and manage your leave requests</p>
        </div>
        <div class="flex items-center space-x-3 mt-4 md:mt-0">
            <a href="{{ route('leaves.create') }}" 
               class="btn-primary inline-flex items-center">
                <i class="fas fa-plus-circle mr-2"></i> Request Leave
            </a>
        </div>
    </div>

    <!-- Leave Statistics -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <div class="card-hover bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl shadow-md p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium opacity-90">Total Leaves</p>
                    <p class="text-2xl font-bold">{{ $stats['total'] }} days</p>
                </div>
                <div class="w-12 h-12 rounded-full bg-white/20 flex items-center justify-center">
                    <i class="fas fa-calendar-alt text-xl"></i>
                </div>
            </div>
        </div>

        <div class="card-hover bg-gradient-to-r from-green-500 to-green-600 rounded-xl shadow-md p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium opacity-90">Used Leaves</p>
                    <p class="text-2xl font-bold">{{ $stats['used'] }} days</p>
                </div>
                <div class="w-12 h-12 rounded-full bg-white/20 flex items-center justify-center">
                    <i class="fas fa-calendar-check text-xl"></i>
                </div>
            </div>
        </div>

        <div class="card-hover bg-gradient-to-r from-yellow-500 to-yellow-600 rounded-xl shadow-md p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium opacity-90">Available</p>
                    <p class="text-2xl font-bold">{{ $stats['available'] }} days</p>
                </div>
                <div class="w-12 h-12 rounded-full bg-white/20 flex items-center justify-center">
                    <i class="fas fa-calendar text-xl"></i>
                </div>
            </div>
        </div>

        <div class="card-hover bg-gradient-to-r from-purple-500 to-purple-600 rounded-xl shadow-md p-6 text-white">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm font-medium opacity-90">Pending</p>
                    <p class="text-2xl font-bold">{{ $stats['pending'] }} days</p>
                </div>
                <div class="w-12 h-12 rounded-full bg-white/20 flex items-center justify-center">
                    <i class="fas fa-clock text-xl"></i>
                </div>
            </div>
        </div>
    </div>

    <!-- Progress Bar -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 p-6 mb-8">
        <div class="flex items-center justify-between mb-2">
            <h3 class="font-medium text-gray-800">Annual Leave Usage</h3>
            <span class="text-sm text-gray-600">{{ $stats['used'] }} of {{ $stats['total'] }} days used</span>
        </div>
        <div class="h-4 bg-gray-200 rounded-full overflow-hidden">
            <div class="h-full bg-gradient-to-r from-blue-500 to-purple-600 rounded-full" 
                 style="width: {{ min(100, ($stats['used'] / $stats['total']) * 100) }}%"></div>
        </div>
        <div class="flex justify-between text-xs text-gray-500 mt-2">
            <span>0 days</span>
            <span>{{ round($stats['total'] / 2) }} days</span>
            <span>{{ $stats['total'] }} days</span>
        </div>
    </div>

    <!-- My Leaves Table -->
    <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-100 bg-gray-50">
            <h2 class="text-lg font-semibold text-gray-800">My Leave Requests</h2>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Leave Details
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Period
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Duration
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Status
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                            Actions
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @forelse($leaves as $leave)
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4">
                            <div>
                                @php
                                    $typeIcons = [
                                        'sick' => 'fas fa-heartbeat text-red-500',
                                        'vacation' => 'fas fa-umbrella-beach text-blue-500',
                                        'personal' => 'fas fa-user text-yellow-500',
                                        'emergency' => 'fas fa-exclamation-triangle text-purple-500'
                                    ];
                                @endphp
                                <div class="flex items-center">
                                    <i class="{{ $typeIcons[$leave->type] }} mr-2"></i>
                                    <span class="font-medium text-gray-900">{{ ucfirst($leave->type) }} Leave</span>
                                </div>
                                <div class="text-sm text-gray-600 mt-1">
                                    {{ Str::limit($leave->reason, 80) }}
                                </div>
                                <div class="text-xs text-gray-500 mt-1">
                                    Submitted: {{ $leave->created_at->format('M d, Y') }}
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-sm text-gray-900">
                                <div class="flex items-center">
                                    <i class="fas fa-calendar-day text-gray-400 mr-2"></i>
                                    {{ $leave->start_date->format('M d, Y') }}
                                </div>
                                <div class="flex items-center mt-1">
                                    <i class="fas fa-calendar-alt text-gray-400 mr-2"></i>
                                    {{ $leave->end_date->format('M d, Y') }}
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <div class="text-center">
                                <div class="text-2xl font-bold text-gray-800">{{ $leave->days }}</div>
                                <div class="text-sm text-gray-500">days</div>
                            </div>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            @php
                                $statusColors = [
                                    'pending' => 'bg-yellow-100 text-yellow-800',
                                    'approved' => 'bg-green-100 text-green-800',
                                    'rejected' => 'bg-red-100 text-red-800'
                                ];
                            @endphp
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium {{ $statusColors[$leave->status] }}">
                                <i class="fas fa-circle mr-1 text-{{ 
                                    $leave->status == 'pending' ? 'yellow' : 
                                    ($leave->status == 'approved' ? 'green' : 'red') 
                                }}-500" style="font-size: 8px;"></i>
                                {{ ucfirst($leave->status) }}
                            </span>
                            
                            @if($leave->status != 'pending')
                            <div class="mt-2">
                                <div class="text-xs text-gray-600">
                                    <i class="fas fa-user-check mr-1"></i>
                                    {{ $leave->approvedBy->name ?? 'Admin' }}
                                </div>
                                @if($leave->admin_notes)
                                <div class="text-xs text-gray-500 mt-1">
                                    <i class="fas fa-comment-alt mr-1"></i>
                                    {{ Str::limit($leave->admin_notes, 60) }}
                                </div>
                                @endif
                            </div>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <div class="flex items-center space-x-2">
                                @if($leave->status == 'pending')
                                <form action="{{ route('leaves.destroy', $leave) }}" 
                                      method="POST" 
                                      class="inline"
                                      onsubmit="return confirmDelete()">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            class="text-red-600 hover:text-red-900 transition-colors duration-200"
                                            title="Cancel Request">
                                        <i class="fas fa-times"></i> Cancel
                                    </button>
                                </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="5" class="px-6 py-12 text-center">
                            <div class="flex flex-col items-center justify-center">
                                <div class="w-24 h-24 mb-4 text-gray-300">
                                    <i class="fas fa-calendar-times text-6xl"></i>
                                </div>
                                <h3 class="text-lg font-medium text-gray-700 mb-2">No Leave Requests</h3>
                                <p class="text-gray-500 mb-6">You haven't submitted any leave requests yet.</p>
                                <a href="{{ route('leaves.create') }}" 
                                   class="btn-primary inline-flex items-center">
                                    <i class="fas fa-plus-circle mr-2"></i> Request Leave
                                </a>
                            </div>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        @if($leaves->hasPages())
        <div class="bg-gray-50 px-6 py-4 border-t border-gray-100">
            {{ $leaves->links() }}
        </div>
        @endif
    </div>

    <!-- Upcoming Approved Leaves -->
    @php
        $upcomingLeaves = auth()->user()->leaveRequests()
            ->where('status', 'approved')
            ->where('start_date', '>', now())
            ->orderBy('start_date')
            ->take(3)
            ->get();
    @endphp
    
    @if($upcomingLeaves->count() > 0)
    <div class="mt-8 bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-100 bg-green-50">
            <h2 class="text-lg font-semibold text-gray-800">Upcoming Approved Leaves</h2>
        </div>
        <div class="p-6">
            <div class="space-y-4">
                @foreach($upcomingLeaves as $leave)
                <div class="flex items-center justify-between p-4 border border-green-100 rounded-lg bg-green-50">
                    <div class="flex items-center">
                        <div class="w-10 h-10 rounded-full bg-green-100 flex items-center justify-center">
                            <i class="fas fa-calendar-check text-green-600"></i>
                        </div>
                        <div class="ml-4">
                            <div class="font-medium text-gray-900">{{ ucfirst($leave->type) }} Leave</div>
                            <div class="text-sm text-gray-600">
                                {{ $leave->start_date->format('M d') }} - {{ $leave->end_date->format('M d, Y') }}
                            </div>
                        </div>
                    </div>
                    <div class="text-right">
                        <div class="text-lg font-bold text-gray-800">{{ $leave->days }} days</div>
                        <div class="text-sm text-gray-500">
                            In {{ $leave->start_date->diffInDays(now()) }} days
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
    </div>
    @endif
</div>

<script>
function confirmDelete() {
    return confirm('Are you sure you want to cancel this leave request? This action cannot be undone.');
}
</script>
@endsection