@extends('layouts.dashboard')

@section('title', 'Live Tracking Map')

@section('content')
<div class="container mx-auto px-4">
    <h1 class="text-2xl font-bold text-gray-800 mb-6">Live Tracking Map</h1>
    
    <div class="bg-white shadow rounded-lg p-4 mb-6">
        <div class="mb-4">
            <h2 class="text-lg font-semibold">Interactive Map</h2>
            <p class="text-gray-600">Real-time employee tracking</p>
        </div>
        
        <!-- Simple Map Container -->
        <div id="map" style="height: 500px; width: 100%; border: 1px solid #ddd; border-radius: 0.5rem;"></div>
        
        <div class="mt-4 flex space-x-3">
            <button onclick="centerMap()" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">
                Center Map
            </button>
            <button onclick="addMarkers()" class="px-4 py-2 bg-green-600 text-white rounded hover:bg-green-700">
                Add Test Markers
            </button>
            <a href="{{ route('live-tracking.index') }}" class="px-4 py-2 bg-gray-600 text-white rounded hover:bg-gray-700">
                Back to Dashboard
            </a>
        </div>
    </div>
    
    <!-- Status -->
    <div class="bg-gray-50 p-4 rounded-lg">
        <h3 class="font-semibold mb-2">Status:</h3>
        <p id="status">Ready to load map...</p>
    </div>
</div>

<!-- Load Leaflet -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
let map;
let markers = [];

document.addEventListener('DOMContentLoaded', function() {
    console.log('DOM loaded, creating map...');
    document.getElementById('status').textContent = 'Creating map...';
    
    try {
        // Create map centered on Cairo
        map = L.map('map').setView([30.0444, 31.2357], 13);
        
        // Add OpenStreetMap tiles
        L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
            attribution: '© OpenStreetMap contributors'
        }).addTo(map);
        
        // Add initial marker
        L.marker([30.0444, 31.2357])
            .addTo(map)
            .bindPopup('Map is working!<br>GPS Tracking System')
            .openPopup();
        
        console.log('Map created successfully!');
        document.getElementById('status').textContent = 'Map loaded successfully!';
        
    } catch (error) {
        console.error('Error:', error);
        document.getElementById('status').textContent = 'Error: ' + error.message;
        document.getElementById('status').style.color = 'red';
    }
});

function centerMap() {
    if (map) {
        map.setView([30.0444, 31.2357], 13);
        document.getElementById('status').textContent = 'Map centered at ' + new Date().toLocaleTimeString();
    }
}

function addMarkers() {
    if (!map) return;
    
    // Clear existing markers
    markers.forEach(marker => map.removeLayer(marker));
    markers = [];
    
    // Add test markers
    const testLocations = [
        [30.0444, 31.2357, 'Central Office'],
        [30.0489, 31.2386, 'Client A'],
        [30.0400, 31.2330, 'Client B'],
        [30.0550, 31.2450, 'Warehouse'],
        [30.0350, 31.2250, 'Branch Office']
    ];
    
    testLocations.forEach(([lat, lng, title]) => {
        const marker = L.marker([lat, lng])
            .addTo(map)
            .bindPopup(title);
        markers.push(marker);
    });
    
    document.getElementById('status').textContent = 'Added ' + markers.length + ' test markers';
}
</script>
@endsection