@extends('layouts.dashboard')

@section('title', 'Export Installation Required')

@section('content')
<div class="container mx-auto px-4 py-6">
    <div class="max-w-2xl mx-auto">
        <div class="bg-white rounded-xl shadow-sm border border-gray-100 overflow-hidden">
            <div class="p-8">
                <div class="text-center mb-6">
                    <div class="w-20 h-20 mx-auto mb-4 bg-yellow-100 rounded-full flex items-center justify-center">
                        <i class="fas fa-exclamation-triangle text-yellow-600 text-3xl"></i>
                    </div>
                    <h1 class="text-2xl font-bold text-gray-800">Package Installation Required</h1>
                    <p class="text-gray-600 mt-2">To export reports in {{ $package == 'excel' ? 'Excel' : 'PDF' }} format, you need to install the required package.</p>
                </div>

                <div class="bg-gray-50 rounded-lg p-6 mb-6">
                    <h3 class="font-semibold text-gray-800 mb-3">Installation Instructions</h3>
                    
                    <div class="space-y-4">
                        <div>
                            <p class="text-sm font-medium text-gray-700 mb-1">1. Run the following command in your terminal:</p>
                            <div class="bg-gray-800 text-gray-100 p-4 rounded-lg font-mono text-sm">
                                {{ $install_command }}
                            </div>
                        </div>
                        
                        <div>
                            <p class="text-sm font-medium text-gray-700 mb-1">2. After installation, publish the configuration (if needed):</p>
                            <div class="bg-gray-800 text-gray-100 p-4 rounded-lg font-mono text-sm">
                                @if($package == 'excel')
                                php artisan vendor:publish --provider="Maatwebsite\Excel\ExcelServiceProvider" --tag=config
                                @else
                                php artisan vendor:publish --provider="Barryvdh\DomPDF\ServiceProvider"
                                @endif
                            </div>
                        </div>
                        
                        <div>
                            <p class="text-sm font-medium text-gray-700 mb-1">3. Clear the cache:</p>
                            <div class="bg-gray-800 text-gray-100 p-4 rounded-lg font-mono text-sm">
                                php artisan config:clear<br>
                                php artisan cache:clear
                            </div>
                        </div>
                    </div>
                </div>

                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                    <div class="flex items-center">
                        <i class="fas fa-info-circle text-blue-500 mr-3 text-xl"></i>
                        <div>
                            <p class="font-medium text-blue-800">Note</p>
                            <p class="text-blue-700 text-sm mt-1">
                                {{ $package == 'excel' 
                                    ? 'The Excel export feature allows you to download reports in .xlsx format for further analysis in Microsoft Excel, Google Sheets, or other spreadsheet applications.' 
                                    : 'The PDF export feature allows you to generate professional-looking reports that can be printed or shared digitally while preserving formatting.' 
                                }}
                            </p>
                        </div>
                    </div>
                </div>

                <div class="flex justify-between items-center">
                    <a href="{{ route('admin.reports.index') }}" class="btn-secondary">
                        <i class="fas fa-arrow-left mr-2"></i> Back to Reports
                    </a>
                    
                    <div class="text-sm text-gray-500">
                        Need help? Contact your system administrator.
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection