#!/bin/bash

echo "=== Setting up Innovaxcess Attendance on Live Server ==="
echo "Domain: https://gps.innoverahub.com"
echo ""

# Step 1: Move to correct directory
echo "1. Checking current directory..."
if [ -d "public" ]; then
    echo "   ✓ Public directory exists"
else
    echo "   ✗ ERROR: Public directory not found!"
    exit 1
fi

# Step 2: Set proper permissions
echo "2. Setting permissions..."
chmod -R 755 storage
chmod -R 755 bootstrap/cache
chmod 644 .env

# Step 3: Create storage link
echo "3. Creating storage link..."
php artisan storage:link

# Step 4: Run migrations
echo "4. Running migrations..."
php artisan migrate --force

# Step 5: Clear and cache config
echo "5. Caching configuration..."
php artisan config:clear
php artisan config:cache
php artisan route:cache
php artisan view:cache

# Step 6: Create session table
echo "6. Setting up sessions..."
php artisan session:table
php artisan migrate --force

# Step 7: Create admin user if not exists
echo "7. Creating admin user..."
php artisan tinker --execute="
if (!\App\Models\User::where('email', 'admin@innovaxcess.com')->exists()) {
    \$user = \App\Models\User::create([
        'name' => 'Admin User',
        'email' => 'admin@innovaxcess.com',
        'password' => bcrypt('Admin@123'),
        'employee_id' => 'ADM001',
        'phone' => '+1234567890',
        'status' => 'active'
    ]);
    \$user->assignRole('admin');
    echo 'Admin user created: admin@innovaxcess.com / Admin@123';
} else {
    echo 'Admin user already exists';
}
"

echo ""
echo "=== SETUP COMPLETE ==="
echo "Please check:"
echo "1. Web server points to: $(pwd)/public"
echo "2. Database connection in .env is correct"
echo "3. SSL certificate is installed"
echo ""
echo "Access: https://gps.innoverahub.com"
echo "Login: admin@innovaxcess.com / Admin@123"