

<?php $__env->startSection('title', 'Department Management'); ?>

<?php $__env->startSection('content'); ?>
<div class="container mx-auto px-4 py-6">
    <!-- Header -->
    <div class="flex flex-col md:flex-row md:items-center md:justify-between mb-8">
        <div>
            <h1 class="text-2xl font-bold text-gray-900 mb-2">Department Management</h1>
            <p class="text-gray-600">Manage your company departments and their details</p>
        </div>
        <a href="<?php echo e(route('departments.create')); ?>" 
           class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition duration-200 mt-4 md:mt-0">
            <i class="fas fa-plus-circle mr-2"></i> Create Department
        </a>
    </div>

    <!-- Stats Cards -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-lg bg-blue-50 text-blue-600">
                    <i class="fas fa-building text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Total Departments</p>
                    <p class="text-2xl font-bold text-gray-900"><?php echo e($departments->total()); ?></p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-lg bg-green-50 text-green-600">
                    <i class="fas fa-check-circle text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Active Departments</p>
                    <p class="text-2xl font-bold text-gray-900">
                        <?php echo e(\App\Models\Department::where('status', 'active')->count()); ?>

                    </p>
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg border border-gray-200 shadow-sm p-6 hover:shadow-md transition-shadow duration-200">
            <div class="flex items-center">
                <div class="p-3 rounded-lg bg-red-50 text-red-600">
                    <i class="fas fa-times-circle text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-600">Inactive Departments</p>
                    <p class="text-2xl font-bold text-gray-900">
                        <?php echo e(\App\Models\Department::where('status', 'inactive')->count()); ?>

                    </p>
                </div>
            </div>
        </div>
    </div>

    <!-- Departments Table -->
    <div class="bg-white rounded-lg border border-gray-200 shadow-sm overflow-hidden">
        <?php if($departments->count() > 0): ?>
        <div class="overflow-x-auto">
            <table class="w-full">
                <thead class="bg-gray-50 border-b border-gray-200">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-building mr-2"></i> DEPARTMENT
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-users mr-2"></i> EMPLOYEES
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-info-circle mr-2"></i> STATUS
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-calendar mr-2"></i> CREATED
                            </div>
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-gray-700 uppercase tracking-wider">
                            <div class="flex items-center">
                                <i class="fas fa-cog mr-2"></i> ACTIONS
                            </div>
                        </th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="hover:bg-gray-50 transition-colors duration-150">
                        <td class="px-6 py-4">
                            <div class="flex items-center">
                                <div class="h-10 w-10 flex-shrink-0">
                                    <div class="h-10 w-10 rounded-lg bg-blue-500 flex items-center justify-center">
                                        <i class="fas fa-building text-white"></i>
                                    </div>
                                </div>
                                <div class="ml-4">
                                    <div class="text-sm font-medium text-gray-900"><?php echo e($department->name); ?></div>
                                    <div class="text-sm text-gray-500 truncate max-w-xs"><?php echo e($department->description ?? 'No description'); ?></div>
                                </div>
                            </div>
                        </td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-blue-100 text-blue-800">
                                <i class="fas fa-users mr-1"></i>
                                <?php echo e($department->users()->count()); ?> employees
                            </span>
                        </td>
                        <td class="px-6 py-4">
                            <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium 
                                <?php echo e($department->status == 'active' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'); ?>">
                                <i class="fas fa-circle mr-1 text-<?php echo e($department->status == 'active' ? 'green' : 'red'); ?>-500" style="font-size: 8px;"></i>
                                <?php echo e(ucfirst($department->status)); ?>

                            </span>
                        </td>
                        <td class="px-6 py-4 text-sm text-gray-900">
                            <?php echo e($department->created_at->format('M d, Y')); ?>

                            <div class="text-xs text-gray-500"><?php echo e($department->created_at->diffForHumans()); ?></div>
                        </td>
                        <td class="px-6 py-4">
                            <div class="flex items-center space-x-3">
                                <a href="<?php echo e(route('departments.show', $department)); ?>" 
                                   class="text-blue-600 hover:text-blue-900 transition-colors duration-200"
                                   title="View Department">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="<?php echo e(route('departments.edit', $department)); ?>" 
                                   class="text-yellow-600 hover:text-yellow-900 transition-colors duration-200"
                                   title="Edit Department">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="<?php echo e(route('departments.destroy', $department)); ?>" 
                                      method="POST" 
                                      class="inline"
                                      onsubmit="return confirmDelete()">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" 
                                            class="text-red-600 hover:text-red-900 transition-colors duration-200"
                                            title="Delete Department">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if($departments->hasPages()): ?>
        <div class="bg-gray-50 px-6 py-4 border-t border-gray-200">
            <?php echo e($departments->links()); ?>

        </div>
        <?php endif; ?>

        <?php else: ?>
        <!-- Empty State -->
        <div class="text-center py-12">
            <div class="w-24 h-24 mx-auto mb-4 text-gray-300">
                <i class="fas fa-building text-6xl"></i>
            </div>
            <h3 class="text-lg font-medium text-gray-700 mb-2">No Departments Found</h3>
            <p class="text-gray-500 mb-6">Get started by creating your first department.</p>
            <a href="<?php echo e(route('departments.create')); ?>" 
               class="inline-flex items-center justify-center px-4 py-2 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition duration-200">
                <i class="fas fa-plus-circle mr-2"></i> Create Department
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>

<script>
function confirmDelete() {
    return confirm('Are you sure you want to delete this department? This action cannot be undone.');
}
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/innoverahub/public_html/gps.innoverahub.com/resources/views/departments/index.blade.php ENDPATH**/ ?>